clear

log using table9_9.smcl, replace
run AttyFee2007Definitions.do
/// Table 9.9 Determinants of Number of Objections per Case
reg lnnumobj lndaysin NY, vce(robust)
outreg2 using table9_9.rtf, replace ///
	label ctitle("NumObj","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 9.9","Determinants of the Number of Objections, Case Level")
reg lnnumobj lndaysin NY DE , vce(robust)
outreg2 using table9_9.rtf, append ///
	label ctitle("NumObj","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)
reg lnnumobj lndaysin NY DE lnassets lnroles yearconfirmed lnfeeexpapp feecom, vce(robust)
outreg2 using table9_9.rtf, append ///
	label ctitle("NumObj","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)

/// This creates a residual of fee and expense apps using the best evaluative model
/// and then plugs the residual into the objections regression, to see if cases with higher than average
/// applications are more likely to have objections.  The answer is no (p=.45)
reg  lnfeeexpapp lnassets lndaysin yearconfirmed saleall lnemployees shop lnroles [pw=pweight], vce(robust)
predict highfees, resid
reg lnnumobj lndaysin NY DE gropper highfees, vce(robust)

log close

/// Table 9.3 chi square test
tabi 454 206 9 7 4 9 \ 129 61 3 1 0 1 , chi

/// Table 9.5 chi square test
tabi 34 6 \ 3 8, chi

/// Table 9.6 chi square test
/// committees vs US Trustees
tabi  2 13 \ 67 52, chi
/// committees vs creditors
tabi 2 13 \ 14 12, chi
